﻿using BitFactory.Logging;
using System.Configuration;
using System;
using System.Linq;
using System.Web;
using VeteransAffairs.Registries.Business;


public class Logging
{
    public static void WriteLogToFile(Exception ex)
    {
        string message = "NULL Exception passed to WriteToLogFile()";

        if (ex != null)
        {
            message = " ::: EXCEPTION= " + ex.ToString();
        }

        WriteLogToFile(message, true);
    }

    public static void WriteLogToFile(string message)
    {
        WriteLogToFile(message, false);
    }

    public static void WriteLogToFile(string message, bool isError)
    {
        string userName;
        string comments;
        try
        {
            userName = HttpContext.Current.User.Identity.Name;
            comments = String.Format("Client IP: {0}:: Session ID: {1}", HttpContext.Current.Request.UserHostAddress, HttpContext.Current.Session.SessionID);
        }
        catch 
        {
            userName = "UNKNOWN";
            comments = "";
        }
        message = "UserId: " + userName + ":: " + message;
        
        string path = GetLogLocation();

        Logger l = new FileLogger(path);

        l.LogInfo(message); 

        //RegistriesLinqDataContext dc = new RegistriesLinqDataContext();
        //int stdRegistryId = 0;
         
        //    var setting = (from s in dc.STD_REGISTRies
        //                    where s.CODE == "TBI"
        //                    select s.ID).SingleOrDefault();

        
        //    if (setting != null)
        //    {
        //        stdRegistryId = Convert.ToInt32(setting);
        //    }
       

       // if (stdRegistryId > 0)
       // {
            if (userName.Length > 30)
            {
                userName = userName.Substring(0, 30);
            }
            var numReferrals = SqlProvider.ExecuteScalar("RegistryConnectionString", "CRS_SP_INS_CRSDBLOG", new object[] { 2, (isError ? 1:0), "TBI Logger", message, comments, userName });
        //}
    }

    public static string GetLogLocation()
    {
        //Global g = new Global();
        return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + "_TBI.log";
    }
}


